//
//  MCToggleButtonBar.h
//  MCApplication
//
//  Created by Ali Lalani on 3/6/05.
//  Copyright 2005 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@interface MCToggleButtonBar : NSView {
	BOOL hasSoloStrip;
	BOOL inSoloMode;
	NSMutableArray *buttons;
	
	int soloPressed;
	int buttonPressed;

	id target;
	SEL action;	
}

// Configuration
- (void)configureWithButtons:(NSArray *)array;

// Button Conveniences
- (int)indexOfButtonAtPoint:(NSPoint)aPoint;
- (int)indexOfSoloAtPoint:(NSPoint)aPoint;
- (NSArray *)activeButtons;
- (void)deactiveAllButtons;
- (void)activateAllButtons;
- (void)setButtonsWithIdentifiers:(NSArray *)idents active:(BOOL)flag;

// Button Actions
- (void)buttonClicked:(NSMutableDictionary *)button;
- (void)soloClicked:(NSMutableDictionary *)button;

- (void)sizeToFit;

// ACCESSORS
- (BOOL)hasSoloStrip;
- (void)setHasSoloStrip:(BOOL)flag;

- (NSMutableArray *)buttons;
- (void)setButtons:(NSMutableArray *)aButtons;

- (void)setTarget:(id)aTarget;
- (id)target;

- (SEL)action;
- (void)setAction:(SEL)anAction;
@end
